<?php
/**
 * Copyright (C) 2014-2020 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Kangaroos cannot jump here' );
}

class Ai1wmae_Import_Controller {

	public static function button() {
		return Ai1wm_Template::get_content(
			'import/button',
			array( 'account_id' => get_option( 'ai1wmae_b2_account_id', false ) ),
			AI1WMAE_TEMPLATES_PATH
		);
	}

	public static function picker() {
		Ai1wm_Template::render(
			'import/picker',
			array(),
			AI1WMAE_TEMPLATES_PATH
		);
	}

	public static function bucket( $params = array() ) {
		ai1wm_setup_environment();

		// Set params
		if ( empty( $params ) ) {
			$params = stripslashes_deep( $_GET );
		}

		// Set bucket ID
		$bucket_id = null;
		if ( ! empty( $params['bucket_id'] ) ) {
			$bucket_id = trim( $params['bucket_id'] );
		}

		// Set folder path
		$folder_path = null;
		if ( ! empty( $params['folder_path'] ) ) {
			$folder_path = trailingslashit( $params['folder_path'] );
		}

		// Set Backblaze B2 client
		$b2 = new Ai1wmae_B2_Client(
			get_option( 'ai1wmae_b2_account_id', false ),
			get_option( 'ai1wmae_b2_application_key', false )
		);

		$b2->authorize_account();

		// Get buckets
		$buckets = $b2->list_buckets();

		// Set bucket ID (listBuckets)
		if ( count( $buckets ) === 0 ) {
			$bucket_id = get_option( 'ai1wmae_b2_bucket_id', false );
		}

		// Set bucket structure
		$response = array( 'items' => array(), 'num_hidden_files' => 0 );

		// Loop over items
		if ( $bucket_id ) {

			// Get bucket items
			$items = $b2->list_file_names( $bucket_id, $folder_path );

			// Loop over folders and files
			foreach ( $items as $item ) {
				if ( $item['type'] === 'folder' || pathinfo( $item['name'], PATHINFO_EXTENSION ) === 'wpress' ) {
					$response['items'][] = array(
						'id'        => isset( $item['id'] ) ? $item['id'] : null,
						'name'      => isset( $item['name'] ) ? $item['name'] : null,
						'path'      => isset( $item['path'] ) ? $item['path'] : null,
						'date'      => isset( $item['date'] ) ? human_time_diff( $item['date'] ) : null,
						'size'      => isset( $item['bytes'] ) ? ai1wm_size_format( $item['bytes'] ) : null,
						'bytes'     => isset( $item['bytes'] ) ? $item['bytes'] : null,
						'type'      => isset( $item['type'] ) ? $item['type'] : null,
						'bucket_id' => $bucket_id,
					);
				} else {
					$response['num_hidden_files']++;
				}
			}

			// Sort items by type desc and name asc
			usort( $response['items'], 'Ai1wmae_Import_Controller::sort_by_type_desc_name_asc' );

		} else {

			// Loop over buckets
			foreach ( $buckets as $bucket_id => $bucket_name ) {
				$response['items'][] = array(
					'id'   => $bucket_id,
					'name' => $bucket_name,
					'type' => 'bucket',
				);
			}
		}

		echo json_encode( $response );
		exit;
	}

	public static function sort_by_type_desc_name_asc( $first_item, $second_item ) {
		$sorted_items = strcasecmp( $second_item['type'], $first_item['type'] );
		if ( $sorted_items !== 0 ) {
			return $sorted_items;
		}

		return strcasecmp( $first_item['name'], $second_item['name'] );
	}

	public static function pro() {
		return Ai1wm_Template::get_content( 'import/pro', array(), AI1WMAE_TEMPLATES_PATH );
	}
}
