<?php
/**
 * Copyright (C) 2014-2020 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Kangaroos cannot jump here' );
}

/**
 * Check whether export/import is running
 *
 * @return boolean
 */
function ai1wmae_is_running() {
	if ( isset( $_GET['b2'] ) || isset( $_POST['b2'] ) ) {
		return true;
	}

	return false;
}

/**
 * Check whether current user is Backblaze B2 Admin
 *
 * @return boolean
 */
function ai1wmae_is_admin() {
	return current_user_can( 'ai1wmae_b2_admin' ) || ! get_option( 'ai1wmae_b2_lock_mode', false );
}

/**
 * Get Blackblaze B2 root folder
 *
 * @return mixed
 */
function ai1wmae_get_root_folder() {
	if ( ai1wmae_is_admin() ) {
		return null;
	}

	return array(
		'bucket_id'   => get_option( 'ai1wmae_b2_bucket_id', null ),
		'folder_name' => get_option( 'ai1wmae_b2_folder_name', null ),
	);
}
